<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">


<table style="font-size: 14px;font-family: Gotham, 'Helvetica Neue', Helvetica, Arial, 'sans-serif'; color:#1F497D; border-collapse:collapse;">
	<tr>
		<td valign="top"  width="200px" style="font-weight: bold;text-align: right;">Benefit Priority Group</td>
		<td valign="top" >:</td>
		
		
		<xsl:choose>
         <xsl:when test="//*/enrollmentDeterminationInfo/priorityGroup">
           <td valign="top"  width="100px;" style="padding-left: 10px;"><xsl:value-of disable-output-escaping="yes" select="//*/enrollmentDeterminationInfo/priorityGroup"/></td>
         </xsl:when>
         <xsl:otherwise>
          <td valign="top"  width="100px;" style="padding-left: 10px;">N/A</td>
         </xsl:otherwise>
       </xsl:choose>		
		
		<td valign="top"  style="font-weight: bold;text-align: right;">Date of Death</td>
		<td valign="top" >:</td>
			<xsl:choose>
	         <xsl:when test="//*/deathRecond/deathDate">
	           <xsl:variable name="vdate" select="//*/deathRecond/deathDate"/>
	           <xsl:variable name="vmonth"  select="substring($vdate,5,2)"/>
	           <xsl:variable name="vday"  select="substring($vdate,7,2)"/>
	           <xsl:variable name="vyear"  select="substring($vdate,1,4)"/>
	          <td valign="top"  width="100px;" style="padding-left: 10px;"><xsl:value-of disable-output-escaping="yes" select="concat($vmonth,'/',$vday,'/',$vyear)"/></td>  
	         </xsl:when>
	         <xsl:otherwise>
	          <td valign="top"  width="100px;" style="padding-left: 10px;">N/A</td>
	         </xsl:otherwise>
	       </xsl:choose>		
		<td/>
		<td/>
	</tr>
	

	<tr>
		<td valign="top" style="font-weight: bold;text-align: right;">Service Connected Total<br/>Combined Disability Rating</td>
	 	<td valign="top">:</td>
		<xsl:choose>
         <xsl:when test="//*/enrollmentDeterminationInfo/serviceConnectionAward/serviceConnectedPercentage">
           <td valign="top"  width="100px;" style="padding-left: 10px;"><xsl:value-of disable-output-escaping="yes" select="//*/enrollmentDeterminationInfo/serviceConnectionAward/serviceConnectedPercentage"/></td>
         </xsl:when>
         <xsl:otherwise>
          <td valign="top"  width="100px;" style="padding-left: 10px;">N/A</td>
         </xsl:otherwise>
       </xsl:choose>		
	 
		<td valign="top" style="font-weight: bold;text-align: right;">Eligability For Medicade</td>
		<td valign="top" >:</td>

		<xsl:choose>
         <xsl:when test="//*/enrollmentDeterminationInfo/eligibleForMedicaid">
           <td valign="top"  width="100px;" style="padding-left: 10px;"><xsl:value-of disable-output-escaping="yes" select="//*/enrollmentDeterminationInfo/eligibleForMedicaid"/></td>
         </xsl:when>
         <xsl:otherwise>
          <td valign="top"  width="100px;" style="padding-left: 10px;">N/A</td>
         </xsl:otherwise>
       </xsl:choose>		


		<td/>
		<td/>
	</tr>
 
	<tr height="45px">
		<td  valign="bottom" colspan="8" style="font-weight: bold;text-align: left;">Monetary Benefit Award Status</td>
	</tr>
	<tr>
		<td colspan="8" style="border-bottom: 2px solid;"></td>
	</tr>
	
	<tr>
		<td colspan="2" style="font-weight: bold;">Indicator</td>
		<td colspan="2" style="font-weight: bold;">Type</td>
		<td colspan="2" style="font-weight: bold;">Report Date</td>
		<td colspan="2"/>
	</tr>
	<tr>
		<td colspan="8" style="border-bottom: 1px solid;"></td>
	</tr>
	
	<xsl:choose>
        <xsl:when test="//*/monetaryBenefitAwardInfo/monetaryBenefits/monetaryBenefit">
       
			 <xsl:for-each select = "//*/monetaryBenefitAwardInfo/monetaryBenefits/monetaryBenefit">

				
  				    <xsl:choose>
				      <xsl:when test="position() mod 2 = 0">
						<tr style="background-color:#FCFCFF;">		  
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="monetaryBenefitIndicator"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="type"/></td>
							<xsl:variable name="vdate" select="monetaryBenefitReportDate"/>
							<xsl:variable name="vmonth"  select="substring($vdate,6,2)"/>
							<xsl:variable name="vday"  select="substring($vdate,9,2)"/>
							<xsl:variable name="vyear"  select="substring($vdate,1,4)"/>
							<td valign="top"  width="100px;" colspan="2"><xsl:value-of disable-output-escaping="yes" select="concat($vmonth,'/',$vday,'/',$vyear)"/></td>  
							<td colspan="2"/>
						</tr>			
				      
				      
				      </xsl:when>
				      <xsl:otherwise>
						<tr>		  
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="monetaryBenefitIndicator"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="type"/></td>
							<xsl:variable name="vdate" select="monetaryBenefitReportDate"/>
							<xsl:variable name="vmonth"  select="substring($vdate,6,2)"/>
							<xsl:variable name="vday"  select="substring($vdate,9,2)"/>
							<xsl:variable name="vyear"  select="substring($vdate,1,4)"/>
							<td valign="top"  width="100px;" colspan="2"><xsl:value-of disable-output-escaping="yes" select="concat($vmonth,'/',$vday,'/',$vyear)"/></td>  
							<td colspan="2"/>
						</tr>			
				      
				      
				      </xsl:otherwise>
				    </xsl:choose>			 

				
			</xsl:for-each>
       
       
       
        </xsl:when>
        <xsl:otherwise>
        	<tr>
         		<td valign="top"  colspan="8" style="text-align: center;">no monetary benefit awards found</td>
         	</tr>
        </xsl:otherwise>
      </xsl:choose>		
	
	
	 
	
	<tr height="45px">
		<td  valign="bottom" colspan="8" style="font-weight: bold;text-align: left;">Service Connected Disabilities</td>
	</tr>
	
	
	<tr>
		<td colspan="8" style="border-bottom: 2px solid;"></td>
	</tr>
		
	<tr>
		<td colspan="2" style="font-weight: bold;">Percentage</td>
		<td colspan="2" style="font-weight: bold;">Code</td>
		<td colspan="2" style="font-weight: bold;">Description</td>
		<td colspan="2"/>
	</tr>
	<tr>
		<td colspan="8" style="border-bottom: 1px solid;"></td>
	</tr>	 
	
	
	
	
	<xsl:choose>
        <xsl:when test="//*/enrollmentDeterminationInfo/serviceConnectionAward/ratedDisabilities/ratedDisability">
			 <xsl:for-each select = "//*/enrollmentDeterminationInfo/serviceConnectionAward/ratedDisabilities/ratedDisability"> 
			 
		    		<xsl:choose>
				      <xsl:when test="position() mod 2 = 0">
						<tr style="background-color:#FCFCFF;">		  
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="percentage"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="disabilityCode"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="disability"/></td>
							<td colspan="2"/>
						</tr>			
				      
				      
				      </xsl:when>
				      <xsl:otherwise>
						<tr>
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="percentage"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="disabilityCode"/></td>
							<td valign="top" colspan="2" style=""><xsl:value-of disable-output-escaping="yes" select="disability"/></td>
							<td colspan="2"/>
						</tr>			
				      
				      
				      </xsl:otherwise>
				    </xsl:choose>						 
			 
			 
			</xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
        	<tr>
         		<td valign="top"  colspan="8" style="text-align: center;">no service connected disabilities found</td>
         	</tr>
        </xsl:otherwise>
      </xsl:choose>		
		
	
	
	<tr height="45px">
		<td  valign="bottom" colspan="8" style="font-weight: bold;text-align: left;">Military Service Information</td>
	</tr>
	<tr>
		<td colspan="8" style="border-bottom: 2px solid;"></td>
	</tr>
		
	<tr>
		<td colspan="2" style="font-weight: bold;">Branch</td>
		<td colspan="1" style="font-weight: bold;">Enter Date</td>
		<td colspan="2" style="font-weight: bold;padding-left:20px;">Exit Date</td>
		<td colspan="3" style="font-weight: bold;">Discharge Type</td>
	</tr>
	<tr>
		<td colspan="8" style="border-bottom: 1px solid;"></td>
	</tr>	
	
	

	<xsl:choose>
        <xsl:when test="//*/enrollmentDeterminationInfo/militaryServiceInfo/militaryServiceSiteRecords/militaryServiceSiteRecord/militaryServiceEpisodes/militaryServiceEpisode">
			 <xsl:for-each select = "//*/enrollmentDeterminationInfo/militaryServiceInfo/militaryServiceSiteRecords/militaryServiceSiteRecord/militaryServiceEpisodes/militaryServiceEpisode">
			 
			 
		    		<xsl:choose>
				      <xsl:when test="position() mod 2 = 0">
						<tr style="background-color:#FCFCFF;">		  
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="serviceBranch"/></td>
							<td valign="top" colspan="1" style=""><xsl:value-of disable-output-escaping="yes" select="startDate"/></td>
							<td valign="top" colspan="2" style="padding-left:20px;"><xsl:value-of disable-output-escaping="yes" select="endDate"/></td>
							<td valign="top" colspan="3" style=""><xsl:value-of disable-output-escaping="yes" select="dischargeType"/></td>
						</tr>			
				      
				      
				      </xsl:when>
				      <xsl:otherwise>
						<tr>
							<td colspan="2" valign="top" style=""><xsl:value-of disable-output-escaping="yes" select="serviceBranch"/></td>
							<td valign="top" colspan="1" style=""><xsl:value-of disable-output-escaping="yes" select="startDate"/></td>
							<td valign="top" colspan="2" style="padding-left:20px;"><xsl:value-of disable-output-escaping="yes" select="endDate"/></td>
							<td valign="top" colspan="3" style=""><xsl:value-of disable-output-escaping="yes" select="dischargeType"/></td>						
						</tr>			
				      </xsl:otherwise>
				    </xsl:choose>						 
			 
			  
					<tr>

					</tr>			
			</xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
        	<tr>
         		<td valign="top"  colspan="8" style="text-align: center;">no military sercvice records found</td>
         	</tr>
        </xsl:otherwise>
      </xsl:choose>			
	
	
	
</table>


</xsl:template>
</xsl:stylesheet>
